/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.biometric;

import com.zkteco.biometric.FingerprintSensorErrorCode;
import com.zkteco.biometric.FingerprintSensorEx;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

public class ZKFPDemo
extends JFrame {
    JButton btnOpen = null;
    JButton btnEnroll = null;
    JButton btnVerify = null;
    JButton btnIdentify = null;
    JButton btnRegImg = null;
    JButton btnIdentImg = null;
    JButton btnClose = null;
    JButton btnImg = null;
    JRadioButton radioISO = null;
    JRadioButton radioANSI = null;
    private JTextArea textArea;
    int fpWidth = 0;
    int fpHeight = 0;
    private byte[] lastRegTemp = new byte[2048];
    private int cbRegTemp = 0;
    private byte[][] regtemparray = new byte[3][2048];
    private boolean bRegister = false;
    private boolean bIdentify = true;
    private int iFid = 1;
    private int nFakeFunOn = 1;
    static final int enroll_cnt = 3;
    private int enroll_idx = 0;
    private byte[] imgbuf = null;
    private byte[] template = new byte[2048];
    private int[] templateLen = new int[1];
    private boolean mbStop = true;
    private long mhDevice = 0L;
    private long mhDB = 0L;
    private WorkThread workThread = null;

    public void launchFrame() {
        this.setLayout(null);
        this.btnOpen = new JButton("Open");
        this.add(this.btnOpen);
        int nRsize = 20;
        this.btnOpen.setBounds(30, 10 + nRsize, 100, 30);
        this.btnEnroll = new JButton("Enroll");
        this.add(this.btnEnroll);
        this.btnEnroll.setBounds(30, 60 + nRsize, 100, 30);
        this.btnVerify = new JButton("Verify");
        this.add(this.btnVerify);
        this.btnVerify.setBounds(30, 110 + nRsize, 100, 30);
        this.btnIdentify = new JButton("Identify");
        this.add(this.btnIdentify);
        this.btnIdentify.setBounds(30, 160 + nRsize, 100, 30);
        this.btnRegImg = new JButton("Register By Image");
        this.add(this.btnRegImg);
        this.btnRegImg.setBounds(15, 210 + nRsize, 120, 30);
        this.btnIdentImg = new JButton("Verify By Image");
        this.add(this.btnIdentImg);
        this.btnIdentImg.setBounds(15, 260 + nRsize, 120, 30);
        this.btnClose = new JButton("Close");
        this.add(this.btnClose);
        this.btnClose.setBounds(30, 310 + nRsize, 100, 30);
        this.radioANSI = new JRadioButton("ANSI", true);
        this.add(this.radioANSI);
        this.radioANSI.setBounds(30, 360 + nRsize, 60, 30);
        this.radioISO = new JRadioButton("ISO");
        this.add(this.radioISO);
        this.radioISO.setBounds(120, 360 + nRsize, 60, 30);
        ButtonGroup group = new ButtonGroup();
        group = new ButtonGroup();
        group.add(this.radioANSI);
        group.add(this.radioISO);
        this.btnImg = new JButton();
        this.btnImg.setBounds(150, 5, 256, 300);
        this.btnImg.setDefaultCapable(false);
        this.add(this.btnImg);
        this.textArea = new JTextArea();
        this.add(this.textArea);
        this.textArea.setBounds(10, 440, 480, 100);
        this.setSize(520, 580);
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        this.setTitle("ZKFinger Demo");
        this.setResizable(false);
        this.btnOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0L != ZKFPDemo.this.mhDevice) {
                    ZKFPDemo.this.textArea.setText("Please close device first!");
                    return;
                }
                int ret = FingerprintSensorErrorCode.ZKFP_ERR_OK;
                ZKFPDemo.this.cbRegTemp = 0;
                ZKFPDemo.this.bRegister = false;
                ZKFPDemo.this.bIdentify = false;
                ZKFPDemo.this.iFid = 1;
                ZKFPDemo.this.enroll_idx = 0;
                if (FingerprintSensorErrorCode.ZKFP_ERR_OK != FingerprintSensorEx.Init()) {
                    ZKFPDemo.this.textArea.setText("Init failed!");
                    return;
                }
                ret = FingerprintSensorEx.GetDeviceCount();
                if (ret < 0) {
                    ZKFPDemo.this.textArea.setText("No devices connected!");
                    ZKFPDemo.this.FreeSensor();
                    return;
                }
                long l = FingerprintSensorEx.OpenDevice(0);
                ZKFPDemo.this.mhDevice = l;
                if (0L == l) {
                    ZKFPDemo.this.textArea.setText("Open device fail, ret = " + ret + "!");
                    ZKFPDemo.this.FreeSensor();
                    return;
                }
                long l2 = FingerprintSensorEx.DBInit();
                ZKFPDemo.this.mhDB = l2;
                if (0L == l2) {
                    ZKFPDemo.this.textArea.setText("Init DB fail, ret = " + ret + "!");
                    ZKFPDemo.this.FreeSensor();
                    return;
                }
                int nFmt = 0;
                if (ZKFPDemo.this.radioISO.isSelected()) {
                    nFmt = 1;
                }
                FingerprintSensorEx.DBSetParameter(ZKFPDemo.this.mhDB, 5010, nFmt);
                byte[] paramValue = new byte[4];
                int[] size = new int[]{4};
                FingerprintSensorEx.GetParameters(ZKFPDemo.this.mhDevice, 1, paramValue, size);
                ZKFPDemo.this.fpWidth = ZKFPDemo.byteArrayToInt(paramValue);
                size[0] = 4;
                FingerprintSensorEx.GetParameters(ZKFPDemo.this.mhDevice, 2, paramValue, size);
                ZKFPDemo.this.fpHeight = ZKFPDemo.byteArrayToInt(paramValue);
                ZKFPDemo.this.imgbuf = new byte[ZKFPDemo.this.fpWidth * ZKFPDemo.this.fpHeight];
                ZKFPDemo.this.btnImg.resize(ZKFPDemo.this.fpWidth, ZKFPDemo.this.fpHeight);
                ZKFPDemo.this.mbStop = false;
                ZKFPDemo.this.workThread = new WorkThread();
                ZKFPDemo.this.workThread.start();
                ZKFPDemo.this.textArea.setText("Open succ!");
            }
        });
        this.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ZKFPDemo.this.FreeSensor();
                ZKFPDemo.this.textArea.setText("Close succ!");
            }
        });
        this.btnEnroll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0L == ZKFPDemo.this.mhDevice) {
                    ZKFPDemo.this.textArea.setText("Please Open device first!");
                    return;
                }
                if (!ZKFPDemo.this.bRegister) {
                    ZKFPDemo.this.enroll_idx = 0;
                    ZKFPDemo.this.bRegister = true;
                    ZKFPDemo.this.textArea.setText("Please your finger 3 times!");
                }
            }
        });
        this.btnVerify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0L == ZKFPDemo.this.mhDevice) {
                    ZKFPDemo.this.textArea.setText("Please Open device first!");
                    return;
                }
                if (ZKFPDemo.this.bRegister) {
                    ZKFPDemo.this.enroll_idx = 0;
                    ZKFPDemo.this.bRegister = false;
                }
                if (ZKFPDemo.this.bIdentify) {
                    ZKFPDemo.this.bIdentify = false;
                }
            }
        });
        this.btnIdentify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0L == ZKFPDemo.this.mhDevice) {
                    ZKFPDemo.this.textArea.setText("Please Open device first!");
                    return;
                }
                if (ZKFPDemo.this.bRegister) {
                    ZKFPDemo.this.enroll_idx = 0;
                    ZKFPDemo.this.bRegister = false;
                }
                if (!ZKFPDemo.this.bIdentify) {
                    ZKFPDemo.this.bIdentify = true;
                }
            }
        });
        this.btnRegImg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0L == ZKFPDemo.this.mhDB) {
                    ZKFPDemo.this.textArea.setText("Please open device first!");
                }
                String path = "d:\\test\\fingerprint.bmp";
                byte[] fpTemplate = new byte[2048];
                int[] sizeFPTemp = new int[]{2048};
                int ret = FingerprintSensorEx.ExtractFromImage(ZKFPDemo.this.mhDB, path, 500, fpTemplate, sizeFPTemp);
                if (ret == 0) {
                    ret = FingerprintSensorEx.DBAdd(ZKFPDemo.this.mhDB, ZKFPDemo.this.iFid, fpTemplate);
                    if (ret == 0) {
                        ZKFPDemo zKFPDemo = ZKFPDemo.this;
                        zKFPDemo.iFid = zKFPDemo.iFid + 1;
                        ZKFPDemo.this.cbRegTemp = sizeFPTemp[0];
                        System.arraycopy(fpTemplate, 0, ZKFPDemo.this.lastRegTemp, 0, ZKFPDemo.this.cbRegTemp);
                        ZKFPDemo.this.textArea.setText("enroll succ");
                    } else {
                        ZKFPDemo.this.textArea.setText("DBAdd fail, ret=" + ret);
                    }
                } else {
                    ZKFPDemo.this.textArea.setText("ExtractFromImage fail, ret=" + ret);
                }
            }
        });
        this.btnIdentImg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (0L == ZKFPDemo.this.mhDB) {
                    ZKFPDemo.this.textArea.setText("Please open device first!");
                }
                String path = "d:\\test\\fingerprint.bmp";
                byte[] fpTemplate = new byte[2048];
                int[] sizeFPTemp = new int[]{2048};
                int ret = FingerprintSensorEx.ExtractFromImage(ZKFPDemo.this.mhDB, path, 500, fpTemplate, sizeFPTemp);
                if (ret == 0) {
                    if (ZKFPDemo.this.bIdentify) {
                        int[] fid = new int[1];
                        int[] score = new int[1];
                        ret = FingerprintSensorEx.DBIdentify(ZKFPDemo.this.mhDB, fpTemplate, fid, score);
                        if (ret == 0) {
                            ZKFPDemo.this.textArea.setText("Identify succ, fid=" + fid[0] + ",score=" + score[0]);
                        } else {
                            ZKFPDemo.this.textArea.setText("Identify fail, errcode=" + ret);
                        }
                    } else if (ZKFPDemo.this.cbRegTemp <= 0) {
                        ZKFPDemo.this.textArea.setText("Please register first!");
                    } else {
                        ret = FingerprintSensorEx.DBMatch(ZKFPDemo.this.mhDB, ZKFPDemo.this.lastRegTemp, fpTemplate);
                        if (ret > 0) {
                            ZKFPDemo.this.textArea.setText("Verify succ, score=" + ret);
                        } else {
                            ZKFPDemo.this.textArea.setText("Verify fail, ret=" + ret);
                        }
                    }
                } else {
                    ZKFPDemo.this.textArea.setText("ExtractFromImage fail, ret=" + ret);
                }
            }
        });
        this.setDefaultCloseOperation(3);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ZKFPDemo.this.FreeSensor();
            }
        });
    }

    private void FreeSensor() {
        this.mbStop = true;
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (0L != this.mhDB) {
            FingerprintSensorEx.DBFree(this.mhDB);
            this.mhDB = 0L;
        }
        if (0L != this.mhDevice) {
            FingerprintSensorEx.CloseDevice(this.mhDevice);
            this.mhDevice = 0L;
        }
        FingerprintSensorEx.Terminate();
    }

    public static void writeBitmap(byte[] imageBuf, int nWidth, int nHeight, String path) throws IOException {
        FileOutputStream fos = new FileOutputStream(path);
        DataOutputStream dos = new DataOutputStream(fos);
        int w = (nWidth + 3) / 4 * 4;
        int bfType = 16973;
        int bfSize = 1078 + w * nHeight;
        int bfReserved1 = 0;
        int bfReserved2 = 0;
        int bfOffBits = 1078;
        dos.writeShort(bfType);
        dos.write(ZKFPDemo.changeByte(bfSize), 0, 4);
        dos.write(ZKFPDemo.changeByte(bfReserved1), 0, 2);
        dos.write(ZKFPDemo.changeByte(bfReserved2), 0, 2);
        dos.write(ZKFPDemo.changeByte(bfOffBits), 0, 4);
        int biSize = 40;
        int biWidth = nWidth;
        int biHeight = nHeight;
        int biPlanes = 1;
        int biBitcount = 8;
        int biCompression = 0;
        int biSizeImage = w * nHeight;
        int biXPelsPerMeter = 0;
        int biYPelsPerMeter = 0;
        int biClrUsed = 0;
        int biClrImportant = 0;
        dos.write(ZKFPDemo.changeByte(biSize), 0, 4);
        dos.write(ZKFPDemo.changeByte(biWidth), 0, 4);
        dos.write(ZKFPDemo.changeByte(biHeight), 0, 4);
        dos.write(ZKFPDemo.changeByte(biPlanes), 0, 2);
        dos.write(ZKFPDemo.changeByte(biBitcount), 0, 2);
        dos.write(ZKFPDemo.changeByte(biCompression), 0, 4);
        dos.write(ZKFPDemo.changeByte(biSizeImage), 0, 4);
        dos.write(ZKFPDemo.changeByte(biXPelsPerMeter), 0, 4);
        dos.write(ZKFPDemo.changeByte(biYPelsPerMeter), 0, 4);
        dos.write(ZKFPDemo.changeByte(biClrUsed), 0, 4);
        dos.write(ZKFPDemo.changeByte(biClrImportant), 0, 4);
        int i = 0;
        while (i < 256) {
            dos.writeByte(i);
            dos.writeByte(i);
            dos.writeByte(i);
            dos.writeByte(0);
            ++i;
        }
        byte[] filter = null;
        if (w > nWidth) {
            filter = new byte[w - nWidth];
        }
        int i2 = 0;
        while (i2 < nHeight) {
            dos.write(imageBuf, (nHeight - 1 - i2) * nWidth, nWidth);
            if (w > nWidth) {
                dos.write(filter, 0, w - nWidth);
            }
            ++i2;
        }
        dos.flush();
        dos.close();
        fos.close();
    }

    public static byte[] changeByte(int data) {
        return ZKFPDemo.intToByteArray(data);
    }

    public static byte[] intToByteArray(int number) {
        byte[] abyte = new byte[]{(byte)(0xFF & number), (byte)((0xFF00 & number) >> 8), (byte)((0xFF0000 & number) >> 16), (byte)((0xFF000000 & number) >> 24)};
        return abyte;
    }

    public static int byteArrayToInt(byte[] bytes) {
        int number = bytes[0] & 0xFF;
        number |= bytes[1] << 8 & 0xFF00;
        number |= bytes[2] << 16 & 0xFF0000;
        return number |= bytes[3] << 24 & 0xFF000000;
    }

    private void OnCatpureOK(byte[] imgBuf) {
        try {
            ZKFPDemo.writeBitmap(imgBuf, this.fpWidth, this.fpHeight, "fingerprint.bmp");
            this.btnImg.setIcon(new ImageIcon(ImageIO.read(new File("fingerprint.bmp"))));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void OnExtractOK(byte[] template, int len) {
        if (this.bRegister) {
            int[] fid = new int[1];
            int[] score = new int[1];
            int ret = FingerprintSensorEx.DBIdentify(this.mhDB, template, fid, score);
            if (ret == 0) {
                this.textArea.setText("the finger already enroll by " + fid[0] + ",cancel enroll");
                this.bRegister = false;
                this.enroll_idx = 0;
                return;
            }
            if (this.enroll_idx > 0 && FingerprintSensorEx.DBMatch(this.mhDB, this.regtemparray[this.enroll_idx - 1], template) <= 0) {
                this.textArea.setText("please press the same finger 3 times for the enrollment");
                return;
            }
            System.arraycopy(template, 0, this.regtemparray[this.enroll_idx], 0, 2048);
            ++this.enroll_idx;
            if (this.enroll_idx == 3) {
                int[] _retLen = new int[]{2048};
                byte[] regTemp = new byte[_retLen[0]];
                ret = FingerprintSensorEx.DBMerge(this.mhDB, this.regtemparray[0], this.regtemparray[1], this.regtemparray[2], regTemp, _retLen);
                if (ret == 0 && (ret = FingerprintSensorEx.DBAdd(this.mhDB, this.iFid, regTemp)) == 0) {
                    ++this.iFid;
                    this.cbRegTemp = _retLen[0];
                    System.arraycopy(regTemp, 0, this.lastRegTemp, 0, this.cbRegTemp);
                    String strBase64 = FingerprintSensorEx.BlobToBase64(regTemp, this.cbRegTemp);
                    this.textArea.setText("enroll succ");
                } else {
                    this.textArea.setText("enroll fail, error code=" + ret);
                }
                this.bRegister = false;
            } else {
                this.textArea.setText("You need to press the " + (3 - this.enroll_idx) + " times fingerprint");
            }
        } else if (this.bIdentify) {
            int[] fid = new int[1];
            int[] score = new int[1];
            int ret = FingerprintSensorEx.DBIdentify(this.mhDB, template, fid, score);
            if (ret == 0) {
                this.textArea.setText("Identify succ, fid=" + fid[0] + ",score=" + score[0]);
            } else {
                this.textArea.setText("Identify fail, errcode=" + ret);
            }
        } else if (this.cbRegTemp <= 0) {
            this.textArea.setText("Please register first!");
        } else {
            int ret = FingerprintSensorEx.DBMatch(this.mhDB, this.lastRegTemp, template);
            if (ret > 0) {
                this.textArea.setText("Verify succ, score=" + ret);
            } else {
                this.textArea.setText("Verify fail, ret=" + ret);
            }
        }
    }

    public static void main(String[] args) {
        new ZKFPDemo().launchFrame();
    }

    private class WorkThread
    extends Thread {
        private WorkThread() {
        }

        @Override
        public void run() {
            super.run();
            int ret = 0;
            while (!ZKFPDemo.this.mbStop) {
                ((ZKFPDemo)ZKFPDemo.this).templateLen[0] = 2048;
                ret = FingerprintSensorEx.AcquireFingerprint(ZKFPDemo.this.mhDevice, ZKFPDemo.this.imgbuf, ZKFPDemo.this.template, ZKFPDemo.this.templateLen);
                if (ret == 0) {
                    if (ZKFPDemo.this.nFakeFunOn == 1) {
                        byte[] paramValue = new byte[4];
                        int[] size = new int[]{4};
                        int nFakeStatus = 0;
                        ret = FingerprintSensorEx.GetParameters(ZKFPDemo.this.mhDevice, 2004, paramValue, size);
                        nFakeStatus = ZKFPDemo.byteArrayToInt(paramValue);
                        System.out.println("ret = " + ret + ",nFakeStatus=" + nFakeStatus);
                        if (ret == 0 && (byte)(nFakeStatus & 0x1F) != 31) {
                            ZKFPDemo.this.textArea.setText("Is a fake-finer?");
                            return;
                        }
                    }
                    ZKFPDemo.this.OnCatpureOK(ZKFPDemo.this.imgbuf);
                    ZKFPDemo.this.OnExtractOK(ZKFPDemo.this.template, ZKFPDemo.this.templateLen[0]);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void runOnUiThread(Runnable runnable) {
        }
    }
}

